/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.l2artifacts.content.search.dissolve;

import dev.xkmc.l2artifacts.content.core.ArtifactStats;
import dev.xkmc.l2artifacts.content.core.BaseArtifact;
import dev.xkmc.l2artifacts.content.search.common.AbstractScrollerMenu;
import dev.xkmc.l2artifacts.content.search.token.ArtifactChestToken;
import dev.xkmc.l2artifacts.content.upgrades.StatContainerItem;
import dev.xkmc.l2artifacts.init.registrate.ArtifactMenuRegistry;
import dev.xkmc.l2library.base.menu.base.SpriteManager;
import dev.xkmc.l2library.base.menu.data.IntDataSlot;
import dev.xkmc.l2library.util.code.GenericItemStack;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;

public class DissolveMenu
extends AbstractScrollerMenu<DissolveMenu> {
    private static final SpriteManager MANAGER = new SpriteManager("l2artifacts", "dissolve");
    protected final IntDataSlot select_index;
    private int selected = -1;

    public static DissolveMenu fromNetwork(MenuType<DissolveMenu> type, int wid, Inventory plInv, FriendlyByteBuf buf) {
        int i = buf.readInt();
        return new DissolveMenu(wid, plInv, ArtifactChestToken.of(plInv.f_35978_, i));
    }

    public DissolveMenu(int wid, Inventory plInv, ArtifactChestToken token) {
        super((MenuType)ArtifactMenuRegistry.MT_DISSOLVE.get(), wid, plInv, MANAGER, 2, token, true);
        this.addSlot("input", e -> e.m_41720_() instanceof StatContainerItem && StatContainerItem.getType(e).isEmpty());
        this.addSlot("output", e -> false);
        this.addSlot("grid", e -> false, e -> e.setPickup(() -> false));
        this.select_index = new IntDataSlot((AbstractContainerMenu)this);
        this.reload(true);
    }

    @Override
    protected void reload(boolean changeContent) {
        super.reload(changeContent);
        this.select_index.set(this.selected - this.getScroll() * 6);
    }

    private ItemStack setSelected(int slot) {
        this.selected = slot;
        this.select_index.set(this.selected - this.getScroll() * 6);
        if (this.selected < 0) {
            return ItemStack.f_41583_;
        }
        GenericItemStack<BaseArtifact> art = this.token.getFiltered().get(slot);
        ItemStack ans = this.container.m_8020_(0).m_41720_().m_7968_();
        Optional<ArtifactStats> opt = BaseArtifact.getStats(art.stack());
        if (opt.isEmpty()) {
            return ItemStack.f_41583_;
        }
        StatContainerItem.setStat(ans, opt.get().main_stat.type);
        return ans;
    }

    @Override
    protected void clickSlot(int slot) {
        if (this.container.m_8020_(0).m_41619_()) {
            return;
        }
        if (((BaseArtifact)this.token.getFiltered().get((int)slot).item()).rank != ((StatContainerItem)this.container.m_8020_((int)0).m_41720_()).rank) {
            return;
        }
        this.container.m_6836_(1, this.setSelected(slot));
    }

    public void m_6199_(Container cont) {
        if (!this.player.m_9236_().m_5776_()) {
            if (!cont.m_8020_(0).m_41619_() && this.selected >= 0 && ((BaseArtifact)this.token.getFiltered().get((int)this.selected).item()).rank != ((StatContainerItem)this.container.m_8020_((int)0).m_41720_()).rank) {
                this.container.m_6836_(1, this.setSelected(-1));
            }
            if (cont.m_8020_(0).m_41619_() && this.selected >= 0) {
                this.container.m_6836_(1, this.setSelected(-1));
            }
            if (this.selected >= 0 && cont.m_8020_(1).m_41619_()) {
                this.container.m_8020_(0).m_41774_(1);
                this.removeSelected();
            }
        }
        super.m_6199_(cont);
    }

    private void removeSelected() {
        this.token.list.remove(this.token.getFiltered().get(this.selected).stack());
        this.token.update();
        this.token.save();
        this.setSelected(-1);
        this.reload(true);
    }

    @Override
    protected boolean shouldClear(Container container, int slot) {
        return slot == 0;
    }
}

